package ch.frankel.blog.validation.validator;

import java.util.Date;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import ch.frankel.blog.validation.model.custom.clazz.Person;

/**
 * Checks that a birth date property is before a death date property.
 * 
 * @author <a href="http://blog.frankel.ch">Nicolas Frankel</a>
 */
public class BirthDeathValidator implements
		ConstraintValidator<BirthDeathCoherence, Person> {

	/**
	 * @see javax.validation.ConstraintValidator#initialize(java.lang.annotation.Annotation)
	 */
	public void initialize(BirthDeathCoherence capitalized) {

		// NOTHING TO DO
	}

	/**
	 * @see javax.validation.ConstraintValidator#isValid(java.lang.Object,
	 *      javax.validation.ConstraintValidatorContext)
	 */
	public boolean isValid(Person value, ConstraintValidatorContext context) {

		Date birth = value.getBirthdate();
		Date death = value.getDeathdate();
		
		if (death == null) {
			
			return true;
		}

		if (birth == null) {
			
			return false;
		}
		
		return birth.before(death);
	}
}
